
/*:
 * @target MZ
 * @plugindesc Removes the white flash animation box when clicking on the screen to move the character.
 * @help This plugin disables the white flash animation box that appears when you click on the screen to move the character.
 */

(() => {
    // Overwrite the method to prevent setting a destination with animation
    Game_Temp.prototype.setDestination = function(x, y) {
        this._destinationX = x;
        this._destinationY = y;
    };

    // Overwrite the method to prevent showing the destination animation sprite
    Game_Temp.prototype.clearDestination = function() {
        this._destinationX = null;
        this._destinationY = null;
    };

    // Override createDestination to do nothing
    Spriteset_Map.prototype.createDestination = function() {
        // Do nothing, disable the destination sprite creation
    };

    // Override updateDestination to do nothing
    Spriteset_Map.prototype.updateDestination = function() {
        // Do nothing, disable the destination sprite update
    };
})();
